#pragma once

class CShader
{
private:
	GLuint Shader;

public:
	CShader();
	~CShader();

	operator GLuint ();

	bool Load(char *ShaderFileName, GLenum Type);
};

class CShaderProgram
{
public:
	GLuint *UniformLocations, *AttribLocations;

private:
	CShader VertexShader, FragmentShader;
	GLuint Program;

public:
	CShaderProgram();
	~CShaderProgram();

	operator GLuint ();

	bool Load(char *VertexShaderFileName, char *FragmentShaderFileName);
	void Destroy();
};
